<?php

#	SonicCampGuard
#
#	Copyright (c) 2024 Bundeswehr
#	Diese Anwendung wurde von Cedric Prietz entwickelt.
#	E-Mail: CedricPrietz@bundeswehr.org
#	App: 90-8303-54618
#
#	Letzte Änderung: 23.09.2024

require_once $_SERVER['DOCUMENT_ROOT'] . '/function.inc.php';
pageName("Dashboard");
requireLogin();
initializeDatabaseConnection();
showSessionAlert();
include($_SERVER['DOCUMENT_ROOT'] . '/header.inc.php');
?>

<div class="d-flex justify-content-between align-items-center flex-wrap grid-margin">
    <div>
        <h4 class="mb-md-0">Karte</h4>
        <span class="text-secondary">Interaktive Lageplanung</span>
    </div>
    <div class="d-flex align-items-center flex-wrap text-nowrap">

    </div>
</div>

<div class="row">

    <div class="col-12 col-md-12 order-1 order-xl-2 grid-margin">

        <div class="alert alert-primary mb-4" role="alert">
            <i class="mdi mdi-information-slab-box-outline"></i>
            Die Interaktive Lageplanung befindet sich derzeit noch in der Entwicklung. Einige Funktionen sind
            möglicherweise noch nicht oder nur eingeschränkt nutzbar.
        </div>

        <div class="card">
            <div class="card-header bg-primary text-white">
                Karte
            </div>
            <div id="map" style="height: 600px;"></div>
        </div>
    </div>

</div>

<?php include($_SERVER['DOCUMENT_ROOT'] . '/footer.inc.php'); ?>

<script>
    var map = L.map('map').setView([<?php echo $app_config['map_position']; ?>], 14);
    L.tileLayer('<?php echo $app_config['map_tile']; ?>', {
        attribution: ''
    }).addTo(map);

    <?php
    $sql = "SELECT * 
            FROM Shelters
            WHERE Coordinates IS NOT NULL AND Coordinates != ''
            ORDER BY ID ASC;
            ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($results) {
        foreach ($results as $row) {
            echo "var marker = L.marker([{$row['Coordinates']}], {icon: shelterIcon}).addTo(map);";
            echo "marker.bindPopup('Schutzbau<br><span class=\'text-warning\' style=\'font-size: 18px; font-weight: 600;\'>{$row['Name']}</span><br><br>Telefon: {$row['Phone']}<br>Funk: {$row['Radio']}');";
        }
    }
    ?>
</script>